<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('course_title', 400)->nullable();
			$table->text('course_overview')->nullable();
			$table->text('course_objectives')->nullable();
			$table->text('course_content')->nullable();
			$table->text('details')->nullable();
			$table->string('cover', 255)->nullable();
			$table->string('tags', 400)->nullable();
			$table->string('categories', 400)->nullable();
			$table->tinyInteger('notify_users')->nullable()->default('0');
			$table->float('price')->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}