<?php

namespace Models/CourseLocations;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CourseLocations extends Eloquent {

	protected $table = 'course_locations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function course()
	{
		return $this->belongsTo('Courses', 'course_id');
	}

	public function location()
	{
		return $this->hasOne('Locations', 'location_id');
	}

}