<?php

namespace Models/CourseInstructors;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CourseInstructors extends Model 
{

    protected $table = 'course_instructors';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function course()
    {
        return $this->belongsTo('Courses', 'course_id');
    }

    public function instructor()
    {
        return $this->belongsTo('Instructors', 'instructor_id');
    }

}