<?php

namespace Models/Reservations;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Reservations extends Model 
{

    protected $table = 'reservations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->belongsTo('Users', 'user_id');
    }

    public function course()
    {
        return $this->belongsTo('Courses', 'course_id');
    }

    public function offer_detail()
    {
        return $this->belongsTo('OffersDetails', 'offer_details_id');
    }

}