<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLocationsTable extends Migration {

	public function up()
	{
		Schema::create('locations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('location_title', 400)->nullable();
			$table->string('location_address', 400)->nullable();
			$table->json('coordinates')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('locations');
	}
}