<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOffersTable extends Migration {

	public function up()
	{
		Schema::create('offers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 400)->nullable();
			$table->timestamp('datetime')->nullable();
			$table->string('notes', 400)->nullable();
			$table->tinyInteger('notify_users')->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('offers');
	}
}