<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMediasTable extends Migration {

	public function up()
	{
		Schema::create('medias', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 400)->nullable();
			$table->string('remote_link', 400)->nullable();
			$table->timestamp('datetime')->nullable();
			$table->integer('model_id')->nullable();
			$table->string('model_name', 255)->nullable();
			$table->integer('sort')->nullable();
			$table->tinyInteger('shown_in_medias')->nullable()->default('0');
			$table->integer('category_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('medias');
	}
}