<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Ticket extends Eloquent {

	protected $table = 'tickets';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function project()
	{
		return $this->belongsTo('Project');
	}

	public function comments()
	{
		return $this->hasMany('Comment');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

}