<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function comments()
	{
		return $this->hasMany('Comment');
	}

	public function roles()
	{
		return $this->belongsToMany('Role')->withPivot('role_user');
	}

	public function licenses()
	{
		return $this->hasMany('License');
	}

	public function tickets()
	{
		return $this->hasMany('Ticket');
	}

}