<?php

namespace App\Models;

class BloodType extends Eloquent {

	protected $table = 'blood_types';
	public $timestamps = true;
	protected $fillable = array('name');
	protected $visible = array('name');

	public function notifiedClients()
	{
		return $this->morphToMany('App\Models\Client', 'clientable');
	}

	public function clients()
	{
		return $this->hasMany('App\Models\Client');
	}

	public function donationRequest()
	{
		return $this->hasMany('App\Models\DonationRequest');
	}

}