<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDonationRequestsTable extends Migration {

	public function up()
	{
		Schema::create('donation_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('patient_name');
			$table->string('patient_age');
			$table->smallInteger('blood_type_id')->unsigned();
			$table->smallInteger('bags_count')->unsigned();
			$table->string('hospital_name');
			$table->decimal('lat', 8,6);
			$table->decimal('lng', 9.6);
			$table->smallInteger('city_id')->unsigned();
			$table->string('phone_number');
			$table->text('note');
		});
	}

	public function down()
	{
		Schema::drop('donation_requests');
	}
}