<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('meal_id')->unsigned();
			$table->string('special_order');
			$table->longText('notices');
			$table->enum('payment_method', array(''Payement_when_receiving'', ''online_payment''));
			$table->integer('commissions');
			$table->enum('status', array(''pending'', ''accepted'', ''rejected'', ''delivered'', ''declined''));
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}