<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRestaurantsTable extends Migration {

	public function up()
	{
		Schema::create('restaurants', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('email');
			$table->string('phone');
			$table->integer('address_id')->unsigned();
			$table->string('password');
			$table->integer('minimum');
			$table->integer('delivery_price');
			$table->string('image');
			$table->string('whats_up');
			$table->enum('status', array(''closed'', ''opened''))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('restaurants');
	}
}