<?php

namespace App\Models;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;
	protected $fillable = array('meal_id', 'special_order', 'notices', 'payment_method', 'commissions', 'status');

	public function meals()
	{
		return $this->hasMany('App\Models\Meal');
	}

	public function clients()
	{
		return $this->belongsToMany('App\Models\Client');
	}

	public function restaurants()
	{
		return $this->belongsToMany('App\Models\Restaurant');
	}

	public function notification()
	{
		return $this->hasOne('App\Models\Notification');
	}

}