<?php

namespace App\Models;

class Restaurant extends Eloquent {

	protected $table = 'restaurants';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'phone', 'address_id', 'password', 'minimum', 'delivery_price', 'image', 'whats_up', 'status');

	public function meals()
	{
		return $this->belongsToMany('App\Models\Meal');
	}

	public function address()
	{
		return $this->belongsTo('App\Models\Region');
	}

	public function reviews()
	{
		return $this->hasMany('App\Models\Review');
	}

	public function categories()
	{
		return $this->belongsToMany('App\Models\Sort');
	}

	public function orders()
	{
		return $this->belongsToMany('App\Models\Order');
	}

	public function offers()
	{
		return $this->hasMany('App\Models\Offer');
	}

	public function notifications()
	{
		return $this->belongsToMany('App\Models\Notification');
	}

	public function payments()
	{
		return $this->belongsToMany('App\Models\Payment');
	}

}