<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('surname', 255);
			$table->string('email');
			$table->string('password', 255);
			$table->date('birth_date');
			$table->integer('role_id')->unsigned();
			$table->string('phone_number', 255);
			$table->integer('cart_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}