<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('cart_id')->references('id')->on('shopping_cart')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->foreign('receipt_id')->references('id')->on('receipts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_cart_id_foreign');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->dropForeign('product_receipt_id_foreign');
		});
	}
}