<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('product_import', function(Blueprint $table) {
			$table->foreign('pharmacy_id')->references('id')->on('pharmacy')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('laboratory', function(Blueprint $table) {
			$table->foreign('pharmacy_id')->references('id')->on('pharmacy')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('delegate', function(Blueprint $table) {
			$table->foreign('pharmacy_id')->references('id')->on('pharmacy')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('purchase', function(Blueprint $table) {
			$table->foreign('pharmacy_id')->references('id')->on('pharmacy')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_import', function(Blueprint $table) {
			$table->foreign('pharmacy_id')->references('id')->on('pharmacy')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user', function(Blueprint $table) {
			$table->foreign('pharmacy_id')->references('id')->on('pharmacy')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role', function(Blueprint $table) {
			$table->foreign('pharmacy_id')->references('id')->on('pharmacy')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_import_category', function(Blueprint $table) {
			$table->foreign('pharmacy_id')->references('id')->on('pharmacy')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('product_import', function(Blueprint $table) {
			$table->dropForeign('product_import_pharmacy_id_foreign');
		});
		Schema::table('laboratory', function(Blueprint $table) {
			$table->dropForeign('laboratory_pharmacy_id_foreign');
		});
		Schema::table('delegate', function(Blueprint $table) {
			$table->dropForeign('delegate_pharmacy_id_foreign');
		});
		Schema::table('purchase', function(Blueprint $table) {
			$table->dropForeign('purchase_pharmacy_id_foreign');
		});
		Schema::table('order_import', function(Blueprint $table) {
			$table->dropForeign('order_import_pharmacy_id_foreign');
		});
		Schema::table('user', function(Blueprint $table) {
			$table->dropForeign('user_pharmacy_id_foreign');
		});
		Schema::table('role', function(Blueprint $table) {
			$table->dropForeign('role_pharmacy_id_foreign');
		});
		Schema::table('product_import_category', function(Blueprint $table) {
			$table->dropForeign('product_import_category_pharmacy_id_foreign');
		});
	}
}