<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('user_id')->unsigned();
			$table->enum('status', array('SUBMIT'));
			$table->string('title', 350);
			$table->boolean('is_active')->default(true);
			$table->float('total_price', 8,2);
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}