<?php

namespace App\Models\OrderItem;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrderItem extends Eloquent {

	protected $table = 'order_item';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function order()
	{
		return $this->morphMany('Order', 'order_id');
	}

}