<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDonationRequestsTable extends Migration {

	public function up()
	{
		Schema::create('donation_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->integer('age');
			$table->integer('blood_bags');
			$table->string('hospital_name');
			$table->decimal('latitude', 10.8);
			$table->decimal('longatitude', 10.8);
			$table->integer('city_id')->unsigned();
			$table->integer('phone_number');
			$table->string('comments');
			$table->integer('client_id')->unsigned();
			$table->string('blood_type_id');
		});
	}

	public function down()
	{
		Schema::drop('donation_requests');
	}
}