<?php

namespace App\Models;

class DonationRequest extends Eloquent {

	protected $table = 'donation_requests';
	public $timestamps = true;
	protected $fillable = array('name', 'age', 'blood_bags', 'hospital_name', 'latitude', 'longatitude', 'city_id', 'phone_number', 'comments');

	public function client()
	{
		return $this->belongsTo('App\Models\Client');
	}

	public function bloodtype()
	{
		return $this->belongsTo('App\Models\BloodType');
	}

	public function notification()
	{
		return $this->hasOne('App\Models\Notification');
	}

}