<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('jugadores', function(Blueprint $table) {
			$table->foreign('equipo')->references('id')->on('equipos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('equipos', function(Blueprint $table) {
			$table->foreign('entrenador')->references('id')->on('entrenadores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('jugadores', function(Blueprint $table) {
			$table->dropForeign('jugadores_equipo_foreign');
		});
		Schema::table('equipos', function(Blueprint $table) {
			$table->dropForeign('equipos_entrenador_foreign');
		});
	}
}