<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class WorkOrder extends Model 
{

    protected $table = 'workOrders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function quote()
    {
        return $this->belongsTo('BidQuote', 'id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'id');
    }

}