<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorkOrdersTable extends Migration {

	public function up()
	{
		Schema::create('workOrders', function(Blueprint $table) {
			$table->increments('id');
			$table->softDeletes();
			$table->timestamps();
			$table->integer('onCallTechID')->unsigned()->nullable();
			$table->integer('bidQuoteID')->unsigned();
			$table->datetime('arrivalOnsite');
			$table->string('nocLoginName');
			$table->string('nocLogoutName');
			$table->datetime('troubleShootingCompleted');
			$table->string('manLiftSize');
			$table->datetime('actualRestoralDate');
			$table->string('closeOutComments');
			$table->string('accesChanges');
			$table->datetime('techContactDate');
		});
	}

	public function down()
	{
		Schema::drop('workOrders');
	}
}