<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('companyID')->references('id')->on('companies')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('roleID')->references('id')->on('roles')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('onCallTechID')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('userID')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('technologyID')->references('id')->on('technologies')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('affectedPartID')->references('id')->on('affected')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('configID')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('ticketLife', function(Blueprint $table) {
			$table->foreign('ticketID')->references('id')->on('tickets')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ticketLife', function(Blueprint $table) {
			$table->foreign('userID')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('bidQuotes', function(Blueprint $table) {
			$table->foreign('ticketID')->references('id')->on('tickets')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bidQuotes', function(Blueprint $table) {
			$table->foreign('userID')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('workOrders', function(Blueprint $table) {
			$table->foreign('onCallTechID')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('workOrders', function(Blueprint $table) {
			$table->foreign('bidQuoteID')->references('id')->on('bidQuotes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_companyID_foreign');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_roleID_foreign');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_onCallTechID_foreign');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_userID_foreign');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_technologyID_foreign');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_affectedPartID_foreign');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_configID_foreign');
		});
		Schema::table('ticketLife', function(Blueprint $table) {
			$table->dropForeign('ticketLife_ticketID_foreign');
		});
		Schema::table('ticketLife', function(Blueprint $table) {
			$table->dropForeign('ticketLife_userID_foreign');
		});
		Schema::table('bidQuotes', function(Blueprint $table) {
			$table->dropForeign('bidQuotes_ticketID_foreign');
		});
		Schema::table('bidQuotes', function(Blueprint $table) {
			$table->dropForeign('bidQuotes_userID_foreign');
		});
		Schema::table('workOrders', function(Blueprint $table) {
			$table->dropForeign('workOrders_onCallTechID_foreign');
		});
		Schema::table('workOrders', function(Blueprint $table) {
			$table->dropForeign('workOrders_bidQuoteID_foreign');
		});
	}
}