<?php

namespace App\Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Customer extends Eloquent {

	protected $table = 'customers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('mobile_number', 'id_card');

	public function EndPoints()
	{
		return $this->hasMany('EndPoint');
	}

	public function Loans()
	{
		return $this->hasMany('Loan');
	}

	public function Documents()
	{
		return $this->hasMany('Document');
	}

	public function Messages()
	{
		return $this->hasMany('Message');
	}

}