<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('first_name');
			$table->string('last_name')->nullable();
			$table->string('email');
			$table->string('mobile')->nullable();
			$table->string('email_verified_at')->nullable();
			$table->enum('type', array('Admin', 'Patient', 'Provider'));
			$table->boolean('is_active')->default(True);
			$table->string('is_verified_only_for_implementation')->default('False');
			$table->string('password')->nullable();
			$table->string('gender')->nullable();
			$table->date('date_of_birth')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}