<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyGalleryTable extends Migration {

	public function up()
	{
		Schema::create('company_gallery', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('branch_id');
			$table->string('path', 122);
			$table->bigInteger('company_id');
			$table->enum('type', array('photo', 'vedio'));
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('company_gallery');
	}
}