<?php

namespace App/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Companyrate extends Eloquent {

	protected $table = 'company_rates';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('company_id', 'user_id', 'rate', 'rate_comment');

	public function company()
	{
		return $this->belongsTo('Company', 'company_id');
	}

}