<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyBranchesTable extends Migration {

	public function up()
	{
		Schema::create('company_branches', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('company_id');
			$table->string('name', 122);
			$table->string('phone', 20)->unique();
			$table->string('address', 122);
			$table->string('email', 122)->unique();
			$table->softDeletes();
			$table->timestamps();
			$table->string('end_time', 10);
		});
	}

	public function down()
	{
		Schema::drop('company_branches');
	}
}