<?php

namespace App/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Companybranch extends Eloquent {

	protected $table = 'company_branches';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('company_id', 'name', 'phone', 'address', 'email', 'end_time');

	public function company()
	{
		return $this->belongsTo('App/Models\Company', 'company_id');
	}

	public function companyworkdays()
	{
		return $this->hasMany('App/Models\Companydayswork', 'branch_id');
	}

}