<?php

namespace App/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Companydetail extends Eloquent {

	protected $table = 'companies_details';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('company_id', 'commercial_lines', 'commercial_lines_file', 'taxes_licenses', 'taxes_icenses_file', 'started_date', 'brief', 'company_profile');

	public function company()
	{
		return $this->belongsTo('App/Models\Company', 'company_id');
	}

}