<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FreelanceDirectedSession extends Eloquent {

	protected $table = 'fl_directed_sessions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('fl_users_id', 'directed_session_id');

	public function freelanceUser()
	{
		return $this->belongsTo('App\Models\FreelanceUsers', 'fl_user_id');
	}

	public function directedSession()
	{
		return $this->belongsTo('App\Models\DirectedSession', 'directed_session_id');
	}

}