<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FreelanceJobCategory extends Eloquent {

	protected $table = 'fl_job_categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('fl_users_id', 'category_id', 'status');

	public function category()
	{
		return $this->belongsTo('App\Models\Category', 'category_id', 'id');
	}

	public function freelanceUser()
	{
		return $this->belongsTo('App\Models\FreelanceUsers', 'fl_user_id', 'id');
	}

	public function freelanceVoiceSample()
	{
		return $this->hasMany('App\Models\FreelanceVoiceSample');
	}

}