<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('sites', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('site_users', function(Blueprint $table) {
			$table->foreign('site_id')->references('id')->on('sites')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('blocks', function(Blueprint $table) {
			$table->foreign('site_user_id')->references('id')->on('site_users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('page_templates', function(Blueprint $table) {
			$table->foreign('site_user_id')->references('id')->on('site_users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('block_templates', function(Blueprint $table) {
			$table->foreign('site_user_id')->references('id')->on('site_users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('themes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_meta', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('site_meta', function(Blueprint $table) {
			$table->foreign('site_id')->references('id')->on('sites')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('site_user_meta', function(Blueprint $table) {
			$table->foreign('site_user_id')->references('id')->on('site_users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('revisions', function(Blueprint $table) {
			$table->foreign('site_user_id')->references('id')->on('site_users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->foreign('site_user_id')->references('id')->on('site_users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('site_themes', function(Blueprint $table) {
			$table->foreign('site_id')->references('id')->on('sites')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('site_themes', function(Blueprint $table) {
			$table->foreign('theme_id')->references('id')->on('themes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('site_themes', function(Blueprint $table) {
			$table->foreign('site_user_id')->references('id')->on('site_users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('block_pages', function(Blueprint $table) {
			$table->foreign('site_user_id')->references('id')->on('site_users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('block_pages', function(Blueprint $table) {
			$table->foreign('block_id')->references('id')->on('blocks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('block_pages', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('sites', function(Blueprint $table) {
			$table->dropForeign('sites_user_id_foreign');
		});
		Schema::table('site_users', function(Blueprint $table) {
			$table->dropForeign('site_users_site_id_foreign');
		});
		Schema::table('blocks', function(Blueprint $table) {
			$table->dropForeign('blocks_site_user_id_foreign');
		});
		Schema::table('page_templates', function(Blueprint $table) {
			$table->dropForeign('page_templates_site_user_id_foreign');
		});
		Schema::table('block_templates', function(Blueprint $table) {
			$table->dropForeign('block_templates_site_user_id_foreign');
		});
		Schema::table('themes', function(Blueprint $table) {
			$table->dropForeign('themes_user_id_foreign');
		});
		Schema::table('user_meta', function(Blueprint $table) {
			$table->dropForeign('user_meta_user_id_foreign');
		});
		Schema::table('site_meta', function(Blueprint $table) {
			$table->dropForeign('site_meta_site_id_foreign');
		});
		Schema::table('site_user_meta', function(Blueprint $table) {
			$table->dropForeign('site_user_meta_site_user_id_foreign');
		});
		Schema::table('revisions', function(Blueprint $table) {
			$table->dropForeign('revisions_site_user_id_foreign');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->dropForeign('notes_site_user_id_foreign');
		});
		Schema::table('site_themes', function(Blueprint $table) {
			$table->dropForeign('site_themes_site_id_foreign');
		});
		Schema::table('site_themes', function(Blueprint $table) {
			$table->dropForeign('site_themes_theme_id_foreign');
		});
		Schema::table('site_themes', function(Blueprint $table) {
			$table->dropForeign('site_themes_site_user_id_foreign');
		});
		Schema::table('block_pages', function(Blueprint $table) {
			$table->dropForeign('block_pages_site_user_id_foreign');
		});
		Schema::table('block_pages', function(Blueprint $table) {
			$table->dropForeign('block_pages_block_id_foreign');
		});
		Schema::table('block_pages', function(Blueprint $table) {
			$table->dropForeign('block_pages_page_id_foreign');
		});
	}
}