<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Role extends Model 
{

    protected $table = 'roles';
    public $timestamps = false;

    public function users()
    {
        return $this->hasMany('User');
    }

    public function create_by()
    {
        return $this->hasOne('User', 'create_by');
    }

    public function update_by()
    {
        return $this->hasOne('User', 'update_by');
    }

    public function permissions()
    {
        return $this->belongsToMany('\Permission');
    }

}