<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorkshopServicesTable extends Migration {

	public function up()
	{
		Schema::create('workshop_services', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('workshop_id')->unsigned();
			$table->integer('service_id')->unsigned();
			$table->integer('car_type_id')->unsigned();
			$table->integer('car_model_id')->unsigned();
			$table->boolean('is_active')->default(0);
			$table->float('price');
			$table->datetime('create_at');
			$table->datetime('update_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('workshop_services');
	}
}