<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerServicesTable extends Migration {

	public function up()
	{
		Schema::create('customer_services', function(Blueprint $table) {
			$table->increments('id');
			$table->datetime('create_at');
			$table->datetime('update_at')->nullable();
			$table->integer('customer_id')->unsigned();
			$table->integer('workshop_service_id')->unsigned();
			$table->boolean('is_accept');
			$table->enum('status', array('in-progress', 'reject', 'pending', 'done'));
			$table->integer('receipt_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('customer_services');
	}
}