<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration {

	public function up()
	{
		Schema::create('services', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 200);
			$table->longText('description')->nullable();
			$table->float('system_percentage');
			$table->datetime('create_at');
			$table->datetime('update_at')->nullable();
			$table->integer('create_by')->unsigned();
			$table->integer('update_by')->unsigned()->nullable();
			$table->boolean('is_active')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('services');
	}
}