<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWorkshopsTable extends Migration {

	public function up()
	{
		Schema::create('workshops', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 200);
			$table->longText('address');
			$table->string('zip_code', 200);
			$table->longText('description')->nullable();
			$table->string('email', 200)->unique();
			$table->string('password', 200);
			$table->string('phone', 200);
			$table->time('work_from');
			$table->time('work_to');
			$table->boolean('is_active')->default(0);
			$table->datetime('create_at');
			$table->datetime('update_at')->nullable();
			$table->integer('active_by')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('workshops');
	}
}