<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateResidenceTable extends Migration {

	public function up()
	{
		Schema::create('residence', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->integer('unversity_id')->unsigned();
			$table->integer('city_id')->unsigned();
			$table->text('breif');
			$table->string('residence_type', 255);
			$table->string('cost', 255);
			$table->text('features');
			$table->text('disadvantage')->nullable();
			$table->text('advantage')->nullable();
			$table->integer('image_id')->unsigned();
			$table->integer('institute_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('residence');
	}
}