<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUnversitiesTable extends Migration {

	public function up()
	{
		Schema::create('unversities', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('email', 255)->unique();
			$table->longText('breif');
			$table->string('phone_number', 191);
			$table->text('address');
			$table->decimal('latitudes');
			$table->decimal('longitudes');
			$table->integer('city_id')->unsigned();
			$table->text('credence');
			$table->string('language', 255);
			$table->string('unversity_link', 255);
			$table->integer('admin_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('unversities');
	}
}