<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('address', 255);
			$table->string('name', 255);
			$table->integer('phone')->nullable();
			$table->string('website')->nullable();
			$table->string('logo')->nullable();
			$table->date('start_date');
			$table->date('expected_end_date');
			$table->string('email')->unique();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}