<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLabelDetailsTable extends Migration {

	public function up()
	{
		Schema::create('label_details', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('account_id')->nullable();
			$table->bigInteger('label_id')->nullable();
			$table->bigInteger('association_detail_id')->nullable();
			$table->bigInteger('from_entity_id')->nullable();
			$table->bigInteger('to_entity_id')->nullable();
			$table->string('from_object_name', 255)->nullable();
			$table->string('to_object_name', 255)->nullable();
			$table->timestamps();
			$table->string('internal_name', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('label_details');
	}
}