<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertiesTable extends Migration {

	public function up()
	{
		Schema::create('properties', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('account_id')->nullable();
			$table->bigInteger('object_id')->nullable();
			$table->bigInteger('property_group_id')->nullable();
			$table->smallInteger('rule_group')->nullable();
			$table->string('label', 255)->nullable();
			$table->text('description')->nullable();
			$table->integer('property_type')->nullable();
			$table->tinyInteger('sort_type')->nullable();
			$table->tinyInteger('default')->nullable();
			$table->tinyInteger('archived')->nullable();
			$table->timestamp('archived_at')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('properties');
	}
}