<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConditionalDependentPropertiesTable extends Migration {

	public function up()
	{
		Schema::create('conditional_dependent_properties', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('controlling_property_id')->nullable();
			$table->bigInteger('property_id')->nullable();
			$table->bigInteger('position')->nullable();
			$table->tinyInteger('required')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('conditional_dependent_properties');
	}
}