<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactsTable extends Migration {

	public function up()
	{
		Schema::create('contacts', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('account_id')->nullable();
			$table->bigInteger('owner_id')->nullable();
			$table->bigInteger('object_id')->nullable();
			$table->tinyInteger('status')->nullable();
			$table->string('first_name', 255)->nullable();
			$table->string('last_name', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->text('avatar')->nullable();
			$table->jsonb('properties')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contacts');
	}
}