<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOauthClientsTable extends Migration {

	public function up()
	{
		Schema::create('oauth_clients', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned()->nullable();
			$table->string('name', 255)->nullable();
			$table->string('secret', 100)->nullable();
			$table->string('provider', 255)->nullable();
			$table->text('redirect')->nullable();
			$table->tinyInteger('personal_access_client')->nullable();
			$table->tinyInteger('password_client')->nullable();
			$table->tinyInteger('revoked')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('oauth_clients');
	}
}