<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('UserVouchers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('UserVouchers', function(Blueprint $table) {
			$table->foreign('voucher_id')->references('id')->on('Vouchers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('UserVouchers', function(Blueprint $table) {
			$table->dropForeign('UserVouchers_user_id_foreign');
		});
		Schema::table('UserVouchers', function(Blueprint $table) {
			$table->dropForeign('UserVouchers_voucher_id_foreign');
		});
	}
}